﻿<%@ page language="java" pageEncoding="utf-8" contentType="text/html; charset=UTF-8"%>
<%@ page import="java.util.*"%>
<%@ page import="java.io.*"%>
<%@ page import="java.text.SimpleDateFormat"%>
<%!	
/**
 * 元宝支付 https://18pay.net/
 * 功能：日志类
 * 版本：1.0
 * 日期：2020-01-01
 */

public class Log{
	/**
	 * 写日志，方便测试（看网站需求，也可以改成把记录存入数据库）
	 * @param msg 要写入日志里的文本内容
	 */
	public void info(String msg){
		SimpleDateFormat sdf =  new SimpleDateFormat ("yyyy-MM-dd HH:mm:ss");
		File log = new File(getServletContext().getRealPath("/")+"log.txt");
		 if (!log.exists())//如果文件不存在,则新建
         {
             File parentDir = new File(log.getParent());
             if (!parentDir.exists())//如果所在目录不存在,则新建
             {
                 parentDir.mkdirs();
             }
             try {
				log.createNewFile();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
         }
		//先创建一个writer对象
		Writer writer=null;
		BufferedWriter bw=null;
		try {
			writer=new FileWriter(log,true); //是否覆盖,true表示在末尾添加，false表示覆盖
			bw=new BufferedWriter(writer);
			//开始写入
			bw.write(sdf.format(new Date())+" "+msg+"\r\n");
			//写入大量数据，要刷新缓存区
			bw.flush();
		} catch (Exception e) {
			e.printStackTrace();
		}finally{
			try {
				//先开后关
				if (bw!=null) {
					bw.close();
				}
				if (writer!=null) {
					writer.close();
				}		 
			} catch (IOException e) {   
				e.printStackTrace();
			}
		}
	}	
}
%>