<?php 
	/**
	 * 生成订单号
	 */
	function generateOrderNumber($length=4){
		$date=trim(date('Ymdhis ',time()));
		$number=trim($this->getRandNumber($length));
		return $date.$number;
	 }
	/**
	*生成不重复的随机数字
	*@paramint$start需要生成的数字开始范围
	*@paramint$end结束范围
	*@paramint$length需要生成的随机数个数
	*@returnnumber生成的随机数
	*/
	function getRandNumber($length=4){
		//初始化变量为0
		$connt = 0;
		//建一个新数组
		$temp = array();
		while($connt < $length){
		//在一定范围内随机生成一个数放入数组中
		$temp[] = mt_rand(0, 9);
		//$data = array_unique($temp);
		//去除数组中的重复值用了“翻翻法”，就是用array_flip()把数组的key和value交换两次。这种做法比用 array_unique() 快得多。	
		$data = array_flip(array_flip($temp));
		//将数组的数量存入变量count中	
		$connt = count($data);
		}
		//为数组赋予新的键名
		shuffle($data);
		//数组转字符串
		$str=implode(",", $data);
		//替换掉逗号
		$number=str_replace(',', '', $str);
		return $number;
	}
	/* 1.将数组内非空参数值的参数按照参数名从小到大排序（ASCII码字典序）
	 * 2.然后使URL键值对的格式（即key1=value1&key2=value2…）拼接成字符串
	 */
	function ASCII($params = array()){
		//ksort()对数组按照键名进行升序排序
		ksort($params);
		//reset()内部指针指向数组中的第一个元素
		reset($params);
		//$sign = http_build_query($params, '', '&amp');
		$sign = '';//初始化
		foreach ($params AS $key => $val) { //遍历POST参数
			if ($val == ''||$key == 'sign') continue; //跳过这些不签名
			if ($sign) $sign .= '&'; //第一个字符串签名不加& 其他加&连接起来参数
			$sign .= "$key=$val"; //拼接为url参数形式
		}		
		return $sign;
	}
	/**
	 * 建立跳转请求表单
	 * @param string $url 数据提交跳转到的URL
	 * @param array $data 请求参数数组
	 * @param string $method 提交方式：post或get 默认post
	 * @return string 提交表单的HTML文本
	 */
	function buildRequestForm($url, $data, $method = 'post')
	{
		$sHtml = "<form id='requestForm' name='requestForm' action='".$url."' method='".$method."'>";
		while (list ($key, $val) = each ($data))
		{
			$sHtml.= "<input type='hidden' name='".$key."' value='".$val."' />";
		}
		$sHtml = $sHtml."<input type='submit' value='正在跳转到支付'></form>";
		$sHtml = $sHtml."<script>document.forms['requestForm'].submit();</script>";
		return $sHtml;
	}	