﻿<%
'/**
' * 元宝支付 https://18pay.net/
' * 功能：支付交易接口调试入口页面
' * 版本：1.0
' * 日期：2020-01-01
' * 说明：
' * 以下代码只是为了方便商户测试而提供的样例代码，商户可以根据自己网站的需要，按照技术文档编写,并非一定要使用该代码。
' * 该代码仅供学习和研究聚合支付接口使用，只是提供一个参考。
' */
%>
<!DOCTYPE html>
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">   
    <meta content="width=device-width, initial-scale=1, maximum-scale=1.0, user-scalable=0" name="viewport">
    <title>聚合支付测试 - 元宝支付</title>
    <meta name="keywords" content="聚合支付,移动支付,免签支付,轮询支付,聚合移动支付,三方支付,第三方支付,四方支付,第四方支付,微信支付,支付宝支付,银联支付,京东支付,跨境支付,QQ钱包支付,刷脸支付,收银台,一码付,聚合码,聚合码支付,扫码支付,当面付,支付宝代付,微信代付,企业付款到零钱,转账到支付宝,现金红包">
    <meta name="description" content="元宝支付-移动支付技术服务商，让支付简单、专业、快捷！">
	<link rel="stylesheet" href="static/css/reset.css" type="text/css">
    <link rel="stylesheet" href="static/css/demo.css" type="text/css">
	<!--引入jquery-->
	<script src="static/js/jquery.min.js" charset="utf-8"></script>
	<!--引入layui框架-->
	<link rel="stylesheet" href="static/layui/css/layui.css">
	<script src="static/layui/layui.js" charset="utf-8"></script>
</head>
<body style="background-color:#f9f9f9">
    <div class="w1080 nav">
        <div class="navbox">
            <div class="nav-left">
                <a href="https://18pay.net/"><img src="static/images/logo.png" height="50px"></a>
            </div>
            <div class="nav-right">
                <span>支付体验收银台</span>
            </div>
        </div>
    </div>
	<form class="layui-form" action="pay_api.asp" method="post" onsubmit="return checkFrom()">	
	<input id="payid" name="payid" readonly type="hidden">
	<!--订单金额-->
	<div class="w1040 order-box">
		<div class="order-amount">
			<div class="order-amount-left layui-col-xs12 layui-col-sm6 layui-col-md6">
				商品名称：<input type="text" name="subject" value="购买商品"/>
			</div>
			<div class="order-amount-right layui-col-xs12 layui-col-sm6 layui-col-md6">
				订单金额：<input type="text" class="amount" name="money" value="0.1"/>&nbsp;元
			</div>
		</div>
	</div>
    <!--支付方式-->
    <div class="w1080 pay-box">
			<h3>支付方式</h3>
			<div class="layui-input-block">
				<input type="radio" name="type" lay-filter="paytype" value="1" title="支付宝" checked>				
				<input type="radio" name="type" lay-filter="paytype" value="2" title="微信支付">
				<input type="radio" name="type" lay-filter="paytype" value="3" title="QQ钱包">
			</div>		      
    </div>
    <!--立即支付-->
    <div class="w1040 submit-box">
        <div class="submit-box-item">
            <span>需支付：<strong class="money">0.1</strong>元</span>
            <button type="submit" class="pay-submit">立即支付</button>
        </div>
    </div>
	</form>
    <!--底部-->
    <div class="w1080 footer">
        <p>Copyright &copy; 2020-2022 <a href="https://18pay.net/">元宝支付</a> All Rights Reserved.</p>
    </div>
    <script>
		layui.use(['form'], function () {
			var form = layui.form;
			//此处即为 radio 的监听事件
			form.on('radio(paytype)', function(data){
				//console.log(data.elem); //得到radio原始DOM对象
				//console.log(data.value);//被点击的radio的value值
			});
		});
        $(function () {
            $('.amount').blur(function () {
                var amount = $(this).val();
                $(".money").html(amount);
			});
		});			
		function checkFrom(){				
			//支付金额
			var money = $("input[name='money']").val();
			var regNumber=/^(?!(0[0-9]{0,}$))[0-9]{1,}[.]{0,}[0-9]{0,}$/;
			if(regNumber.test(money)==false){
				layer.msg('金额必须为大于0的数字');
				$("input[name='money']").focus();
				return false;
			}
			//最低充值金额
			if(Number(money)<0.1){
				layer.msg('充值金额不得小于0.1元');
				$("input[name='money']").focus();
				return false;
			}
			//最大充值金额
			if(Number(money)>1000){
				layer.msg('充值金额不得大于1000元');
				$("input[name='money']").focus();
				return false;
			}
            return true;
        }		
    </script>
	<script>		
		 /**
		 * 随机生成18位不重复的订单编号
         * length 随机后缀字符长度，默认为4
		 */
		 function generateOrderNumber(length=4){
			const now = new Date();
			let year=now.getFullYear().toString();
			let month = (now.getMonth() + 1).toString();
			let day = now.getDate().toString();
			let hour = now.getHours().toString();
			let minutes = now.getMinutes().toString();
			let seconds = now.getSeconds().toString();
			// 存放订单号
			let num = '';
			// N位随机数(加在时间戳后面)
			for (var i = 0; i < length; i++)
			{
				num += Math.floor(Math.random() * 10);
			}
  			return year+month+day+hour+minutes+seconds+num;
		}	 
		 //生成订单号
		 var payid = document.getElementById("payid");
		 payid.value = generateOrderNumber();
	</script>
</body>
</html>