<?php
namespace app\pay\controller;
use think\Cache;
// +----------------------------------------------------------------------
// | 本文档由元宝支付（18pay.net）重新优化
// +----------------------------------------------------------------------
// | 最后更新日期：2023年5月8日
// +----------------------------------------------------------------------
class Tool extends \think\Controller{
	//发送物品
	public function sendItems($serverid, $guid, $ip, $port, $productInfo){
	    try{
    	    $url = "http://127.0.0.1:8877/gm";
    		$getdata["server"] = $serverid;
    		$getdata["guid"] = $guid;
    		$getdata["cmd"] = "itemManage";
    		$getdata["subcmd"] = "giveItem";
    		$getdata["ip"] = $ip;
    		$getdata["gmport"] = $port;
    		$getdata["md5"] = md5("#0316-come.c#server*".$serverid."guid*".$guid."cmd*itemManage"."subcmd*giveItem"."#0725-come.c#");
    		$attach_item =json_decode($productInfo["item"],true);
    		//把数组拆分（四个为一组）
    		$big_array = array_chunk($attach_item, 4);
    		foreach($big_array as $k=>$array){ 
    		    $getdata["body"] = json_encode([
        		    "player_list" => [\strval($guid)],
        		    "server_broadcast" => "0",
        		    "content" => $productInfo["desc"],
        		    "items" => $array
    		    ]);
    		    //不建议用file_get_contents，file_get_contents只能发送一次，会导致物品发放不全。
    		    //$url = $url . '?' . http_build_query($getdata);
    		    //file_get_contents($url);
        		http_curl($url,"get",$getdata);
    		}
		    return true;
	    } catch (\Exception $e) {
			return false;
		}
	}
	//获取游戏分区服务器
    public function getGameServer($serverid){
        //使用缓存
		$cachename = "gameServer-".$serverid;
        $gameServer = Cache::get($cachename);
        if(empty($gameServer)){
            $gameServer = \think\Db::name("gameconfig")->where("server", $serverid)->field(true)->find();
             //设置缓存
        	if($gameServer!=null){
    		    Cache::set($cachename,$gameServer,86400); 
        	}
        }
        return $gameServer;
	}
	//获取游戏账号角色
    public function getGameRole($surface,$account){
        if(empty($surface)){
            return null;
        }
        //使用缓存
		$cachename = "gameRole-".$surface.$account;
        $roleList = Cache::get($cachename);
        if(empty($roleList)){
            $user = \think\Db::name("user")->field("Id")->where("account", $account)->find();
    		$database = config("database");	
			$hostport = empty($database["hostport"]) ? '3306' : $database["hostport"];
    		$connect = sprintf("mysql://%s:%s@%s:%d/%s#utf8",$database["username"],$database["password"],$database["hostname"],$hostport,$surface);
    	    //printLog("数据库连接语句：".$connect);
    		$roleList = \think\Db::connect($connect)->table("t_player_info")->field(true)->where('accid', $user["Id"])->select();
    		 //设置缓存
        	if($role!=null){
    		    Cache::set($cachename,$roleList,86400); 
        	}
        }
		//多个角色则返回列表集合
		if(count($roleList)>1){
			return $roleList;
		}else{
			return $roleList[0];
		}
	}
	public function getRole($surface,$accountid,$guid){
        if(empty($surface)){
            return null;
        }
        //使用缓存
		$cachename = "gameRole-".$surface.$accountid.$guid;
        $role = Cache::get($cachename);
        if(empty($role)){
            $database = config("database");	
			$hostport = empty($database["hostport"]) ? '3306' : $database["hostport"];
    		$connect = sprintf("mysql://%s:%s@%s:%d/%s#utf8",$database["username"],$database["password"],$database["hostname"],$hostport,$surface);
    		//printLog("数据库连接语句：".$connect);
            $role = \think\Db::connect($connect)->table("t_player_info")->field(true)->where(["accid" => $accountid,"guid" =>$guid])->find();
    		 //设置缓存
        	if($role!=null){
    		    Cache::set($cachename,$role,86400); 
        	}
        }
		return $role;
	}
}