<?php
namespace app\pay\controller;

class Dopay extends \think\Controller{
    // +----------------------------------------------------------------------
    // | 支付配置 开始
	// | 技术支持：元宝支付(18pay.net)
    // +----------------------------------------------------------------------
    //商户ID（商户编号）
	private $appid;
	//商户密钥
	private $appkey;
	//聚合支付POST提交地址
	private $payurl;
    // +----------------------------------------------------------------------
    // | 支付配置 结束 
    // +----------------------------------------------------------------------
    public function _initialize(){
        //返回数组配置下的某一项属性
        $this->appid = config('yuanbaopay.appid');
        $this->appkey = config('yuanbaopay.appkey');
        $this->payurl = config('yuanbaopay.payurl');
	}
	public function index()
	{
	    if(isset($_GET['account']) && isset($_GET['serverid']) && isset($_GET['guid']) && isset($_GET['productId']) && isset($_GET['timestamp']) && isset($_GET['sign'])){
	        $account = $_GET['account'];
	        $serverid = $_GET['serverid'];
	        $guid = $_GET['guid'];
	        $productId = $_GET['productId'];
	        
	        $timestamp = $_GET['timestamp'];
	        $sign = $_GET['sign'];
	        
	        $signKey = "mwald-sign";
	        $signStr = $account."|".$serverid."|".$guid."|".$timestamp.$signKey;
	        $sign1 = md5($signStr);
	        if($sign1 != $sign){
	            return json(["ret" => 0, "msg" => "签名错误！"]);
	        }
	        
	        $payconfig = \think\Db::name("payconfig")->field(true)->where("id", $productId)->find();
	        if(!$payconfig){
	            return json(["ret" => -1, "msg" => "购买物品不存在"]);
	        }
	        
	        $user = \think\Db::name("user")->field(true)->where("account", $account)->find();
	        if(!$user){
	            return json(["ret" => -1, "msg" => "充值账号不存在"]);
	        }
	        //订单写入数据库
	        $order_id = $this->generateOrderNumber();
            $insert["orderId"] = $order_id;
            $insert["account"] = $account;
            $insert["server"] = $serverid;
            $insert["guid"] = $guid;
            $insert["productId"] = $productId;
            $insert["productName"] = $payconfig["name"];
        	$insert["agent"] = $user["agent"];
        	$insert["price"] = $payconfig["price"];
        	$insert["time"] = date("Y-m-d H:i:s", time());
        	$insert["status"] = 0;
        	\think\Db::name("gamebuy_log")->data($insert)->insert();
    		//支付页面
    		$this->assign("account", $account);
			$this->assign("productName", $payconfig["name"]);
    		$this->assign("money", $payconfig["price"]);
    		$this->assign("orderId", $order_id);
            return $this->fetch("gateway");
	    }else{
	        return json(["ret" => -1, "msg" => "非法访问"]);
	    }
	}
	/**
     * 元宝支付
     * 官网：18pay.net
     */
	public function yuanbaoPay(){
	    $request = \think\Request::instance()->post();
	    //计算签名
    	$postData=array(
    		 "appid" => $this->appid,
    		 "payid" => $request["orderId"],//订单编号
    		 "money" => $request["money"],//提交金额
    		 "type" => $request["paytype"],//支付方式 1：支付宝  2：微信支付
    		 "notify_url" => 'http://'.$_SERVER['HTTP_HOST'].'/pay/notify',
    		 "return_url" => 'http://'.$_SERVER['HTTP_HOST'].'/pay/success',
    		 "subject" => $request["account"],
			 "codesize" => 150,
    	);
    	$stringTemp = $this->ASCII($postData);
    	$postData["sign"] =	$this->md5Sign($stringTemp,$this->appkey);
    	//跳转到支付页面
    	$res = $this->buildRequestForm($this->payurl,$postData);
    	echo $res;
    	exit;
	}
	/**
     * 签名字符串
     * @param $prestr 需要签名的字符串
     * @param $key 私钥
     * return 签名结果
     */
	private function md5Sign($prestr, $key) {
		$prestr = $prestr . $key;
		return md5($prestr);
	}
	/**
     * 验证签名
     * @param $prestr 需要签名的字符串
     * @param $sign 签名结果
     * @param $key 私钥
     * return 签名结果
     */
	private function md5Verify($prestr, $sign, $key) {
		$prestr = $prestr . $key;
		$mysgin = md5($prestr);
		if($mysgin == $sign) {
			return true;
		} else {
			return false;
		}
	}
	/**
	 * 生成订单号
	 */
	 private function generateOrderNumber($length=4){
		$date=trim(date('Ymdhis ',time()));
		$number=trim($this->getRandNumber($length));
		return $date.$number;
	 }
	/**
	*生成不重复的随机数字
	*@paramint$start需要生成的数字开始范围
	*@paramint$end结束范围
	*@paramint$length需要生成的随机数个数
	*@returnnumber生成的随机数
	*/
	private function getRandNumber($length=4){
		//初始化变量为0
		$connt = 0;
		//建一个新数组
		$temp = array();
		while($connt < $length){
		//在一定范围内随机生成一个数放入数组中
		$temp[] = mt_rand(0, 9);
		//$data = array_unique($temp);
		//去除数组中的重复值用了“翻翻法”，就是用array_flip()把数组的key和value交换两次。这种做法比用 array_unique() 快得多。	
		$data = array_flip(array_flip($temp));
		//将数组的数量存入变量count中	
		$connt = count($data);
		}
		//为数组赋予新的键名
		shuffle($data);
		//数组转字符串
		$str=implode(",", $data);
		//替换掉逗号
		$number=str_replace(',', '', $str);
		return $number;
	}
	/* 1.将数组内非空参数值的参数按照参数名从小到大排序（ASCII码字典序）
	 * 2.然后使URL键值对的格式（即key1=value1&key2=value2…）拼接成字符串
	 */
	private function ASCII($params = array()){
		//ksort()对数组按照键名进行升序排序
		ksort($params);
		//reset()内部指针指向数组中的第一个元素
		reset($params);
		//$sign = http_build_query($params, '', '&amp');
		$sign = '';//初始化
		foreach ($params AS $key => $val) { //遍历POST参数
			if ($val == ''||$key == 'sign') continue; //跳过这些不签名
			if ($sign) $sign .= '&'; //第一个字符串签名不加& 其他加&连接起来参数
			$sign .= "$key=$val"; //拼接为url参数形式
		}		
		return $sign;
	}
	/**
	 * 建立跳转请求表单
	 * @param string $url 数据提交跳转到的URL
	 * @param array $data 请求参数数组
	 * @param string $method 提交方式：post或get 默认post
	 * @return string 提交表单的HTML文本
	 */
	private function buildRequestForm($url, $data, $method = 'post')
	{
		$sHtml = "<form id='requestForm' name='requestForm' action='".$url."' method='".$method."'>";
		while (list ($key, $val) = each ($data))
		{
			$sHtml.= "<input type='hidden' name='".$key."' value='".$val."' />";
		}
		$sHtml = $sHtml."<input type='submit' value='正在跳转到支付'></form>";
		$sHtml = $sHtml."<script>document.forms['requestForm'].submit();</script>";
		return $sHtml;
	}
	
}