<?php
// +----------------------------------------------------------------------
// | 本文档由元宝支付（18pay.net）重新优化
// +----------------------------------------------------------------------
// | 最后更新日期：2023年5月8日
// +----------------------------------------------------------------------
use think\Db;
use think\Cache;
/** 
 * 打印日志
 * $msg 日志内容
 */
function printLog($msg) {
	$path=LOG_PATH .date('Y-m-d').".txt";
	file_put_contents($path, "【" . date('Y-m-d H:i:s') . "】\r\n" . $msg . "\r\n\r\n", FILE_APPEND);
}
/**
 * 数据缓存封装函数
 * 调用示例：
	$zoneList = CacheData("zoneList",function(){
		return ZoneModel::field('id,name')->order('id desc')->select();
	},300);
 */
function CacheData($cachename,callable $function,$time=300){
	$data = Cache::get($cachename);
	if (empty($data)) {
		//调用回调事件
		$data = call_user_func($function);
		//设置缓存
		Cache::set($cachename,$data,$time); 
	}
	return $data;
}
//获取游戏分区服务器
function getGameServerList(){
        //使用缓存
		$cachename = "gameServerList";
        $gameServerList = Cache::get($cachename);
        if(empty($gameServerList)){
            $gameServerList = Db::name("gameconfig")->where("state", "1")->select();
             //设置缓存
        	if($gameServerList!=null){
    		    Cache::set($cachename,$gameServerList,86400); 
        	}
        }
        return $gameServerList;
}
function curl_post($url, $data){
    $ch = curl_init();
    $header = ["Accept-Charset" => "utf-8"];
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (compatible; MSIE 5.01; Windows NT 5.0)');
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($ch, CURLOPT_AUTOREFERER, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $tmpInfo = curl_exec($ch);
    if (curl_errno($ch)) {
        return false;
    } else {
        return $tmpInfo;
    }
}