<?php
/*
 * 元宝支付 http://www.18pay.net
 * Date: 2020/12/10
 * Time: 15:38
 * 说明：
 * 以下代码只是为了方便商户测试而提供的样例代码，商户可以根据自己网站的需要，按照技术文档编写,并非一定要使用该代码。
 * 该代码仅供学习和研究接口使用，只是提供一个参考，最终解释权归美奇软件开发工作室所有。
 * 严禁一切钓鱼、色情、赌博、私彩及违反国家法律法规等使用。
 * 注意：
 * UTF-8编码不要在记事本下编辑，否则会出现一些奇葩的问题，正确方法应在开发工具里打开编辑
 */
ini_set("error_reporting","E_ALL & ~E_NOTICE");
header('Content-Type:application/json; charset=utf-8');
require "Des.php";
/////////////////需要修改的参数/////////////////
//商户编号
$appid = '填写平台的商户编号';
//商户密钥
$appkey = '填写平台的商户密钥';
//算法密钥
$deskey='填写平台的算法密钥';  
///////////////////////////////////////////////
//下面代码基本不需要修改
if (empty($_POST)) $_POST = $_GET;  //如果为GET方式访问
if(version_compare(PHP_VERSION,'5.4.0','<')){
	outputError('PHP版本要求大于5.4.0');
}
if(!isset($_POST['appid'])){
	outputError('参数非法');
}
//验证商户号
if($_POST['appid']!=$appid){
	outputError('商户编号不正确');
}
if (!function_exists('openssl_encrypt')){
	outputError('请开启php.ini的openssl扩展');
}
//解密接口参数
$des = new Des();
$parameter=$_POST['parameter'];
$decode=$des->decrypt($parameter,$deskey);
if(empty($decode)){
	outputError('算法密钥不正确');
}
parse_str($decode, $data);
//验证商户密钥
if($appkey!=$data['appkey']){
	outputError('商户密钥不正确');
}

//开始充值
chongzhi($data);
function chongzhi($data){
	try{
		$dbhost = isset($data['dbhost']) ? $data['dbhost'] : '127.0.0.1';
		$dbuser = $data['dbuser'];
		$dbname = $data['dbname'];
		$dbpswd = $data['dbpswd'];
		$dbport = isset($data['dbport']) ? $data['dbport'] : '3306';
		$mysqli=new mysqli($dbhost,$dbuser,$dbpswd,$dbname,$dbport);
		if($mysqli->connect_error){
			outputError("数据库连接失败");
		}
		//默认参数
		$account = $data['account'];
		$money = $data['money'];
		//读出sql的baser64
		$sqls = htmlspecialchars_decode(stripslashes(base64_decode($data['sql'])));
		$sqls = str_replace("&#39;","'",$sqls);
		$sqls = str_replace(array("\r\n","\r","\n")," ",$sqls);
		//分割为多个sql
		$sqla = preg_split("/;/",$sqls);
		foreach($sqla as $k => $v){
			$sql = trim($v);
			if($sql==''){
				continue;
			}
			//替换sql:兼容派爱
			$sql = str_replace("{account}",$account,$sql);
			$sql = str_replace("{money}",$money,$sql);
			//替换sql:兼容利宝
			$sql = str_replace(":username",$account,$sql);
			$sql = str_replace(":money",$money,$sql);
			//执行SQL语句
			$result = $mysqli->query($sql);
			if(!$result){
				outputError("执行sql失败，SQL语句：".$sql);
			}
		}
		//成功返回
		$msg = sprintf("账号[%s]成功充值金额%s元",$account,$money);
		outputSuccess($msg);
	} catch (\Exception $e) {
		outputError('充值异常，Error：'.$e->getMessage());
	}
}

function outputError($msg){
	$arr=array('code'=>0,'msg'=>$msg);
	echo json_encode($arr, JSON_UNESCAPED_UNICODE);
	exit;
}

function outputSuccess($msg){
	$arr=array('code'=>1,'msg'=>$msg);
	echo json_encode($arr, JSON_UNESCAPED_UNICODE);
	exit;
}

/** 
 * 打印日志
 * $msg 日志内容
 */
function printLog($msg) {
	if (!is_dir('log')){
		mkdir('log',0777,true);
	}
	$path="log/".date('Y-m-d').".log";
	file_put_contents($path, "【" . date('Y-m-d H:i:s') . "】" . $msg . "\r\n\r\n", FILE_APPEND);
}